/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.updates;

import com.ibm.hwmca.base.updates.ChangeConsoleIntCodeBean;
import com.ibm.hwmca.base.updates.ChangeConsoleIntCodeConstants;
import com.ibm.hwmca.base.updates.ChangeConsoleIntCodeResponseData;
import com.ibm.hwmca.base.updates.ChangeMgmtInfo;
import com.ibm.hwmca.base.updates.CheckDependenciesBean;
import com.ibm.hwmca.base.updates.DependCheckingFailBean;
import com.ibm.hwmca.base.updates.RetrieveIntCodeBean;
import com.ibm.hwmca.base.updates.SelectInternalCodeBean;
import com.ibm.hwmca.base.updates.SpecificRequestNotPossibleException;
import com.ibm.hwmca.base.updates.SpecifyIntCodeChgsBean;
import com.ibm.hwmca.base.updates.SpecifyPrefillData;
import com.ibm.hwmca.base.updates.StartChgEndChgBean;
import com.ibm.hwmca.base.updates.UpdateUtilities;
import com.ibm.hwmca.base.updates.UpdatesErrorIds;
import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.base.util.BaseMessageTitle;
import com.ibm.hwmca.base.util.BaseTextBundle;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.mediasvc.MediaDevice;
import com.ibm.hwmca.fw.mediasvc.MediaDeviceException;
import com.ibm.hwmca.fw.mediasvc.MediaServicesBusyInterface;
import com.ibm.hwmca.fw.mediasvc.MediaServicesUtil;
import com.ibm.hwmca.fw.mediasvc.MediaServicesUtilException;
import com.ibm.hwmca.fw.msgpanel.CommonMsgInterface;
import com.ibm.hwmca.fw.persist.PersistenceException;
import com.ibm.hwmca.fw.persist.PersistenceInvalidNameException;
import com.ibm.hwmca.fw.persist.PersistenceIsParentException;
import com.ibm.hwmca.fw.persist.PersistenceManager;
import com.ibm.hwmca.fw.persist.PersistenceWriteException;
import com.ibm.hwmca.fw.system.RestartManager;
import com.ibm.hwmca.fw.task.ProgressCancelListener;
import com.ibm.hwmca.fw.task.ProgressData;
import com.ibm.hwmca.fw.task.ProgressEndEvent;
import com.ibm.hwmca.fw.task.ProgressEndedListener;
import com.ibm.hwmca.fw.task.ProgressStartEvent;
import com.ibm.hwmca.fw.task.ProgressUpdateEvent;
import com.ibm.hwmca.fw.tasklet.DisplayAreaDescriptorDelegate;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.PanelTaskletProgressListener;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.updates.DependencyException;
import com.ibm.hwmca.xfw.updates.MissingDependencyException;
import com.ibm.hwmca.xfw.updates.Update;
import com.ibm.hwmca.xfw.updates.UpdateCollection;
import com.ibm.hwmca.xfw.updates.UpdateLevel;
import com.ibm.hwmca.xfw.updates.UpdateManager;
import com.ibm.hwmca.xfw.updates.UpdateRange;
import com.ibm.hwmca.xfw.updates.UpdateableComponent;
import com.ibm.hwmca.xfw.updates.Updater;
import com.ibm.hwmca.xfw.updates.UpdatesOwner;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class ChangeConsoleIntCodeTasklet
extends PanelTasklet
implements ChangeConsoleIntCodeConstants,
UpdatesErrorIds,
CommonMsgInterface,
ProgressEndedListener,
MediaServicesBusyInterface {
    private static final String TRACE_MASKT = "XMCLCCTT";
    private static final String TRACE_MASKF = "XMCLCCTF";
    private static final String TRACE_MASKD = "XMCLCCTD";
    private static final String RESTART_CLASS = "com.ibm.hwmca.base.updates.ChangeConsoleIntCodeRestartTasklet";
    private UpdateManager theUpdateManager;
    private List allUpdaters = null;
    private PanelHandler currentPanel;
    private static boolean progressDismissed;
    private static Object progressWaiters;
    private int savedTrack;
    private int savedImportExportOperationType;
    private int savedCheckDependencyType;
    private PanelTaskletProgressListener savedProgListener;
    private MediaServicesUtil savedMediaServUtil = null;
    private Long estimatedDuration;
    private File mountPoint;
    private LocalizableText progPanelStartMsg;
    private int mediaType;
    private List specificList;
    private boolean isBusyDesiredForMediaOperations = true;
    LocalizableText busyMessage = null;
    private static final String PROGRESS_PANEL_ID = "ChangeConsoleProgID";
    private static final String PERSISTENT_DATA_KEY = "com.ibm.hwmca.base.updates.SpecifyPrefillData";
    private static final String SYS_INFO_CLASS = "com.ibm.hwmca.base.sysinfo.SysInfoTasklet";
    private static final String CONFIG_SPECIFIC_CLASS = "com.ibm.hwmca.base.updates.ChangeConsConfigSpecificTasklet";
    private static final FrameworkClassLogInfo classLogInfo;
    private static final String DATA_TERMINATE = "terminate";
    private static final String DATA_RESTART = "restart";
    private static final String DATA_REFRESH = "refresh";
    private PanelHandler ChgIntCodePanelHandler = new PanelHandler(){

        public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
            Trace.trace(ChangeConsoleIntCodeTasklet.TRACE_MASKT, "-> ChangeConsoleIntCodeTasklet.ChgIntCodePanelHandler");
            try {
                if (request.isDisposed() || request.isCanceled()) {
                    Trace.trace(ChangeConsoleIntCodeTasklet.TRACE_MASKF, " [ChgIntCodePanelHandler.service()] Terminate task because the main panel is being disposed.");
                    response.terminate();
                } else {
                    String radioButton = (String)request.getData("radioButton");
                    Trace.trace(ChangeConsoleIntCodeTasklet.TRACE_MASKF, " [ChgIntCodePanelHandler.service()] The selected radio button is '" + radioButton + "'");
                    if (radioButton.equalsIgnoreCase("AcceptInstalledChangesChoice")) {
                        ChangeConsoleIntCodeTasklet.this.savedTrack = 1;
                        ChangeConsoleIntCodeTasklet.this.currentPanel = ChangeConsoleIntCodeTasklet.this.SelectIntCodeChgsPanelHandler;
                        response.openModalChild("com.ibm.hwmca.base.updates.res.ChangeConsoleIntCodeRes", "SelectIntCodeChgsPanel", new SelectInternalCodeBean());
                    } else if (radioButton.equalsIgnoreCase("CheckDependenciesChoice")) {
                        ChangeConsoleIntCodeTasklet.this.savedTrack = 2;
                        ChangeConsoleIntCodeTasklet.this.currentPanel = ChangeConsoleIntCodeTasklet.this.CheckDependenciesPanelHandler;
                        response.openModalChild("com.ibm.hwmca.base.updates.res.ChangeConsoleIntCodeRes", "CheckDependenciesPanel", new CheckDependenciesBean());
                    } else if (radioButton.equalsIgnoreCase("InstallAndActivateChangesChoice")) {
                        ChangeConsoleIntCodeTasklet.this.savedTrack = 3;
                        ChangeConsoleIntCodeTasklet.this.currentPanel = ChangeConsoleIntCodeTasklet.this.SelectIntCodeChgsPanelHandler;
                        response.openModalChild("com.ibm.hwmca.base.updates.res.ChangeConsoleIntCodeRes", "SelectIntCodeChgsPanel", new SelectInternalCodeBean());
                    } else if (radioButton.equalsIgnoreCase("BrowseSystemInternalCodeChoice")) {
                        ChangeConsoleIntCodeTasklet.this.savedTrack = 4;
                        DisplayAreaDescriptorDelegate theDelegate = new DisplayAreaDescriptorDelegate(ChangeConsoleIntCodeTasklet.SYS_INFO_CLASS, null);
                        response.openModalChild(theDelegate);
                    } else if (radioButton.equalsIgnoreCase("RemoveActivateChangesChoice")) {
                        ChangeConsoleIntCodeTasklet.this.savedTrack = 5;
                        ChangeConsoleIntCodeTasklet.this.currentPanel = ChangeConsoleIntCodeTasklet.this.SelectIntCodeChgsPanelHandler;
                        response.openModalChild("com.ibm.hwmca.base.updates.res.ChangeConsoleIntCodeRes", "SelectIntCodeChgsPanel", new SelectInternalCodeBean());
                    } else if (radioButton.equalsIgnoreCase("RetrieveInternalCodeChgsChoice")) {
                        ChangeConsoleIntCodeTasklet.this.savedTrack = 6;
                        ChangeConsoleIntCodeTasklet.this.currentPanel = ChangeConsoleIntCodeTasklet.this.RetrieveIntCodePanelHandler;
                        response.openModalChild("com.ibm.hwmca.base.updates.res.ChangeConsoleIntCodeRes", "RetrieveIntCodePanel", new RetrieveIntCodeBean());
                    } else if (radioButton.equalsIgnoreCase("SelectConfigSpecChgsChoice")) {
                        ChangeConsoleIntCodeTasklet.this.savedTrack = 7;
                        DisplayAreaDescriptorDelegate subtaskDelegate = new DisplayAreaDescriptorDelegate(ChangeConsoleIntCodeTasklet.CONFIG_SPECIFIC_CLASS, null);
                        if (null != subtaskDelegate) {
                            Trace.trace(ChangeConsoleIntCodeTasklet.TRACE_MASKT, " [ChgIntCodePanelHandler.service()] Open subtasklet to display config specific panel.");
                            response.openModalChild(subtaskDelegate);
                        } else {
                            Trace.trace(ChangeConsoleIntCodeTasklet.TRACE_MASKT, " [ChgIntCodePanelHandler.service()] Got NULL subtasklet delegate. Ignore request for config specific panel.");
                            response.noAction();
                        }
                    } else if (radioButton.equalsIgnoreCase("DeleteRetrievedChgsChoice")) {
                        ChangeConsoleIntCodeTasklet.this.savedTrack = 8;
                        ChangeConsoleIntCodeTasklet.this.currentPanel = ChangeConsoleIntCodeTasklet.this.SelectIntCodeChgsPanelHandler;
                        response.openModalChild("com.ibm.hwmca.base.updates.res.ChangeConsoleIntCodeRes", "SelectIntCodeChgsPanel", new SelectInternalCodeBean());
                    } else {
                        Trace.trace(ChangeConsoleIntCodeTasklet.TRACE_MASKF, " [ChgIntCodePanelHandler.service()] Ignore unknown radio button '" + radioButton + "'");
                        response.noAction();
                    }
                }
            }
            catch (Exception e) {
                Trace.trace(ChangeConsoleIntCodeTasklet.TRACE_MASKT, " [ChgIntCodePanelHandler.service()] caught exception: " + e);
                e.printStackTrace();
                new FrameworkLog(classLogInfo, -251, e).log();
                Trace.trace(ChangeConsoleIntCodeTasklet.TRACE_MASKT, " [ChgIntCodePanelHandler.service()] Terminate task due to unrecoverable error.");
                response.terminate();
            }
            Trace.trace(ChangeConsoleIntCodeTasklet.TRACE_MASKT, "<- ChangeConsoleIntCodeTasklet.ChgIntCodePanelHandler");
        }
    };
    private PanelHandler SelectIntCodeChgsPanelHandler = new PanelHandler(){

        public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
            Trace.trace(ChangeConsoleIntCodeTasklet.TRACE_MASKT, "-> ChangeConsoleIntCodeTasklet.SelectIntCodeChgsPanelHandler");
            if (request.isDisposed() || request.isCanceled()) {
                if (ChangeConsoleIntCodeTasklet.this.savedTrack == 6) {
                    ChangeConsoleIntCodeTasklet.this.currentPanel = ChangeConsoleIntCodeTasklet.this.RetrieveIntCodePanelHandler;
                } else {
                    ChangeConsoleIntCodeTasklet.this.currentPanel = ChangeConsoleIntCodeTasklet.this.ChgIntCodePanelHandler;
                }
                response.dispose();
            } else {
                String radioButton = (String)request.getData("radioButton");
                Trace.trace(ChangeConsoleIntCodeTasklet.TRACE_MASKF, " [SelectIntCodeChgsPanelHandler.service()] The selected radio button is '" + radioButton + "'");
                if (radioButton.equalsIgnoreCase("AllIntCodeChgsChoice")) {
                    switch (ChangeConsoleIntCodeTasklet.this.savedTrack) {
                        case 1: {
                            ChangeConsoleIntCodeTasklet.this.performCommitUpdates(response, null);
                            break;
                        }
                        case 3: {
                            ChangeConsoleIntCodeTasklet.this.performApplyUpdates(response, null);
                            break;
                        }
                        case 5: {
                            ChangeConsoleIntCodeTasklet.this.performRejectUpdates(response, null);
                            break;
                        }
                        case 6: {
                            ChangeConsoleIntCodeTasklet.this.performImportExport(response, null);
                            break;
                        }
                        case 8: {
                            ChangeConsoleIntCodeTasklet.this.performDeleteUpdates(response, null);
                        }
                    }
                } else if (radioButton.equalsIgnoreCase("SpecificIntCodeChgsChoice")) {
                    SpecifyIntCodeChgsBean bean = new SpecifyIntCodeChgsBean();
                    try {
                        PersistenceManager persMgr = PersistenceManager.getPersistenceManager();
                        if (persMgr.contains(ChangeConsoleIntCodeTasklet.PERSISTENT_DATA_KEY)) {
                            Trace.trace(ChangeConsoleIntCodeTasklet.TRACE_MASKD, " [SelectIntCodeChgsPanelHandler.service()] About to read persistent data.");
                            SpecifyPrefillData persistedData = (SpecifyPrefillData)persMgr.read(ChangeConsoleIntCodeTasklet.PERSISTENT_DATA_KEY);
                            bean.initializeWithServerData(persistedData.getSpecifyPanelData());
                            Trace.trace(ChangeConsoleIntCodeTasklet.TRACE_MASKD, " [SelectIntCodeChgsPanelHandler.service()] Back from read of persistent data.");
                        }
                    }
                    catch (PersistenceException pe) {
                        Trace.trace(ChangeConsoleIntCodeTasklet.TRACE_MASKT, " [SelectIntCodeChgsPanelHandler.service()] caught exception: " + pe);
                        pe.printStackTrace();
                    }
                    ChangeConsoleIntCodeTasklet.this.currentPanel = ChangeConsoleIntCodeTasklet.this.SpecifyIntCodeChgsPanelHandler;
                    response.openModalChild("com.ibm.hwmca.base.updates.res.ChangeConsoleIntCodeRes", "SpecifyIntCodeChgsPanel", bean);
                } else {
                    Trace.trace(ChangeConsoleIntCodeTasklet.TRACE_MASKF, " [SelectIntCodeChgsPanelHandler.service()] Ignore unknown radio button '" + radioButton + "'");
                    response.noAction();
                }
            }
            Trace.trace(ChangeConsoleIntCodeTasklet.TRACE_MASKT, "<- ChangeConsoleIntCodeTasklet.SelectIntCodeChgsPanelHandler");
        }
    };
    private PanelHandler SpecifyIntCodeChgsPanelHandler = new PanelHandler(){

        public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
            Trace.trace(ChangeConsoleIntCodeTasklet.TRACE_MASKT, "-> ChangeConsoleIntCodeTasklet.SpecifyIntCodeChgsPanelHandler");
            if (request.isDisposed() || request.isCanceled()) {
                if (ChangeConsoleIntCodeTasklet.this.savedTrack == 2) {
                    ChangeConsoleIntCodeTasklet.this.currentPanel = ChangeConsoleIntCodeTasklet.this.CheckDependenciesPanelHandler;
                } else {
                    ChangeConsoleIntCodeTasklet.this.currentPanel = ChangeConsoleIntCodeTasklet.this.SelectIntCodeChgsPanelHandler;
                }
                response.dispose();
            } else {
                List ulList = (List)request.getData("userData");
                if (ulList.isEmpty()) {
                    Trace.trace(ChangeConsoleIntCodeTasklet.TRACE_MASKF, " [SpecifyIntCodeChgsPanelHandler.service()] Ignoring request since no valid EC number and level combinations specified.");
                    response.noAction();
                } else if (ChangeConsoleIntCodeTasklet.this.isUpdateLevelListValid(ulList)) {
                    SpecifyPrefillData newVal = new SpecifyPrefillData(ulList);
                    try {
                        PersistenceManager persMgr = PersistenceManager.getPersistenceManager();
                        Trace.trace(ChangeConsoleIntCodeTasklet.TRACE_MASKD, " [SpecifyIntCodeChgsPanelHandler.service()] About to write persistent data.");
                        persMgr.write(ChangeConsoleIntCodeTasklet.PERSISTENT_DATA_KEY, newVal);
                        Trace.trace(ChangeConsoleIntCodeTasklet.TRACE_MASKD, " [SpecifyIntCodeChgsPanelHandler.service()] Back after write of persistent data.");
                    }
                    catch (PersistenceWriteException pwe) {
                        Trace.trace(ChangeConsoleIntCodeTasklet.TRACE_MASKT, " [SpecifyIntCodeChgsPanelHandler.service()] caught PersistenceWriteException: " + pwe);
                        pwe.printStackTrace();
                    }
                    catch (PersistenceInvalidNameException pine) {
                        Trace.trace(ChangeConsoleIntCodeTasklet.TRACE_MASKT, " [SpecifyIntCodeChgsPanelHandler.service()] caught PersistenceInvalidNameException: " + pine);
                        pine.printStackTrace();
                    }
                    catch (PersistenceIsParentException pipe) {
                        Trace.trace(ChangeConsoleIntCodeTasklet.TRACE_MASKT, " [SpecifyIntCodeChgsPanelHandler.service()] caught PersistenceIsParentException: " + pipe);
                        pipe.printStackTrace();
                    }
                    catch (PersistenceException pe) {
                        Trace.trace(ChangeConsoleIntCodeTasklet.TRACE_MASKT, " [SpecifyIntCodeChgsPanelHandler.service()] caught PersistenceException: " + pe);
                        pe.printStackTrace();
                    }
                    switch (ChangeConsoleIntCodeTasklet.this.savedTrack) {
                        case 1: {
                            ChangeConsoleIntCodeTasklet.this.performCommitUpdates(response, ulList);
                            break;
                        }
                        case 3: {
                            ChangeConsoleIntCodeTasklet.this.performApplyUpdates(response, ulList);
                            break;
                        }
                        case 5: {
                            ChangeConsoleIntCodeTasklet.this.performRejectUpdates(response, ulList);
                            break;
                        }
                        case 6: {
                            ChangeConsoleIntCodeTasklet.this.performImportExport(response, ulList);
                            break;
                        }
                        case 8: {
                            ChangeConsoleIntCodeTasklet.this.performDeleteUpdates(response, ulList);
                            break;
                        }
                        case 2: {
                            ChangeConsoleIntCodeTasklet.this.performCheckDependencies(response, ulList);
                        }
                    }
                } else {
                    Trace.trace(ChangeConsoleIntCodeTasklet.TRACE_MASKF, " [SpecifyIntCodeChgsPanelHandler.service()] Ignoring request since isUpdateLevelListValid() returned false.");
                    response.noAction();
                }
            }
            Trace.trace(ChangeConsoleIntCodeTasklet.TRACE_MASKT, "<- ChangeConsoleIntCodeTasklet.SpecifyIntCodeChgsPanelHandler");
        }
    };
    private PanelHandler CheckDependenciesPanelHandler = new PanelHandler(){

        public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
            Trace.trace(ChangeConsoleIntCodeTasklet.TRACE_MASKT, "-> ChangeConsoleIntCodeTasklet.CheckDependenciesPanelHandler");
            if (request.isDisposed() || request.isCanceled()) {
                ChangeConsoleIntCodeTasklet.this.currentPanel = ChangeConsoleIntCodeTasklet.this.ChgIntCodePanelHandler;
                response.dispose();
            } else {
                String radioButton = (String)request.getData("radioButton");
                Trace.trace(ChangeConsoleIntCodeTasklet.TRACE_MASKF, " [CheckDependenciesPanelHandler.service()] The selected radio button is '" + radioButton + "'");
                if (radioButton.equalsIgnoreCase("InstallActivateAllChoice")) {
                    ChangeConsoleIntCodeTasklet.this.savedCheckDependencyType = 1;
                } else if (radioButton.equalsIgnoreCase("RemoveActivateAllChoice")) {
                    ChangeConsoleIntCodeTasklet.this.savedCheckDependencyType = 2;
                } else if (radioButton.equalsIgnoreCase("InstallActivateSpecificChoice")) {
                    ChangeConsoleIntCodeTasklet.this.savedCheckDependencyType = 3;
                } else if (radioButton.equalsIgnoreCase("RemoveActivateSpecificChoice")) {
                    ChangeConsoleIntCodeTasklet.this.savedCheckDependencyType = 4;
                } else if (radioButton.equalsIgnoreCase("AcceptSpecificChoice")) {
                    ChangeConsoleIntCodeTasklet.this.savedCheckDependencyType = 5;
                } else {
                    Trace.trace(ChangeConsoleIntCodeTasklet.TRACE_MASKF, " [CheckDependenciesPanelHandler.service()] Ignoring unknown radio button '" + radioButton + "'");
                    response.noAction();
                }
                switch (ChangeConsoleIntCodeTasklet.this.savedCheckDependencyType) {
                    case 1: 
                    case 2: {
                        ChangeConsoleIntCodeTasklet.this.performCheckDependencies(response, null);
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        SpecifyIntCodeChgsBean bean = new SpecifyIntCodeChgsBean();
                        try {
                            PersistenceManager persMgr = PersistenceManager.getPersistenceManager();
                            if (persMgr.contains(ChangeConsoleIntCodeTasklet.PERSISTENT_DATA_KEY)) {
                                Trace.trace(ChangeConsoleIntCodeTasklet.TRACE_MASKD, " [CheckDependenciesPanelHandler.service()] About to read persistent data.");
                                SpecifyPrefillData persistedData = (SpecifyPrefillData)persMgr.read(ChangeConsoleIntCodeTasklet.PERSISTENT_DATA_KEY);
                                bean.initializeWithServerData(persistedData.getSpecifyPanelData());
                                Trace.trace(ChangeConsoleIntCodeTasklet.TRACE_MASKD, " [CheckDependenciesPanelHandler.service()] Back from read of persistent data.");
                            }
                        }
                        catch (PersistenceException pe) {
                            Trace.trace(ChangeConsoleIntCodeTasklet.TRACE_MASKT, " [CheckDependenciesPanelHandler.service()] caught exception: " + pe);
                            pe.printStackTrace();
                        }
                        ChangeConsoleIntCodeTasklet.this.currentPanel = ChangeConsoleIntCodeTasklet.this.SpecifyIntCodeChgsPanelHandler;
                        response.openModalChild("com.ibm.hwmca.base.updates.res.ChangeConsoleIntCodeRes", "SpecifyIntCodeChgsPanel", bean);
                    }
                }
            }
            Trace.trace(ChangeConsoleIntCodeTasklet.TRACE_MASKT, "<- ChangeConsoleIntCodeTasklet.CheckDependenciesPanelHandler");
        }
    };
    private PanelHandler DependencyCheckingFailurePanelHandler = new PanelHandler(){

        public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
            Trace.trace(ChangeConsoleIntCodeTasklet.TRACE_MASKT, "-> ChangeConsoleIntCodeTasklet.DependencyCheckingFailurePanelHandler");
            if (request.isDisposed() || request.isCanceled()) {
                ChangeConsoleIntCodeTasklet.this.currentPanel = ChangeConsoleIntCodeTasklet.this.CheckDependenciesPanelHandler;
                response.dispose();
            } else {
                ChangeConsoleIntCodeTasklet.this.currentPanel = ChangeConsoleIntCodeTasklet.this.ChgIntCodePanelHandler;
                response.dispose("CheckDependenciesPanel");
            }
            Trace.trace(ChangeConsoleIntCodeTasklet.TRACE_MASKT, "<- ChangeConsoleIntCodeTasklet.DependencyCheckingFailurePanelHandler");
        }
    };
    private PanelHandler RetrieveIntCodePanelHandler = new PanelHandler(){

        public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
            Trace.trace(ChangeConsoleIntCodeTasklet.TRACE_MASKT, "-> ChangeConsoleIntCodeTasklet.RetrieveIntCodePanelHandler");
            if (request.isDisposed() || request.isCanceled()) {
                ChangeConsoleIntCodeTasklet.this.currentPanel = ChangeConsoleIntCodeTasklet.this.ChgIntCodePanelHandler;
                response.dispose();
            } else {
                String radioButton = (String)request.getData("radioButton");
                Trace.trace(ChangeConsoleIntCodeTasklet.TRACE_MASKF, " [RetrieveIntCodePanelHandler.service()] The selected radio button is '" + radioButton + "'");
                if (radioButton.equalsIgnoreCase("RetrieveFromDiskChoice") || radioButton.equalsIgnoreCase("RetrieveFromDVDChoice") || radioButton.equalsIgnoreCase("RetrieveToDiskChoice") || radioButton.equalsIgnoreCase("RetrieveToDVDChoice")) {
                    boolean repeatLoop;
                    String msgTitleKey;
                    String msgTextKey;
                    boolean mountReadWrite;
                    if (radioButton.equalsIgnoreCase("RetrieveFromDiskChoice")) {
                        ChangeConsoleIntCodeTasklet.this.savedImportExportOperationType = 1;
                        ChangeConsoleIntCodeTasklet.this.mediaType = 1;
                        mountReadWrite = false;
                        Trace.trace(ChangeConsoleIntCodeTasklet.TRACE_MASKD, "Handle 'Retrieve code changes from diskette' choice.");
                    } else if (radioButton.equalsIgnoreCase("RetrieveFromDVDChoice")) {
                        ChangeConsoleIntCodeTasklet.this.savedImportExportOperationType = 2;
                        ChangeConsoleIntCodeTasklet.this.mediaType = 6;
                        mountReadWrite = false;
                        Trace.trace(ChangeConsoleIntCodeTasklet.TRACE_MASKD, "Handle 'Retrieve code changes from DVD' choice.");
                    } else if (radioButton.equalsIgnoreCase("RetrieveToDiskChoice")) {
                        ChangeConsoleIntCodeTasklet.this.savedImportExportOperationType = 4;
                        ChangeConsoleIntCodeTasklet.this.mediaType = 1;
                        mountReadWrite = true;
                        Trace.trace(ChangeConsoleIntCodeTasklet.TRACE_MASKD, "Handle 'Retrieve code changes to diskette' choice.");
                    } else {
                        ChangeConsoleIntCodeTasklet.this.savedImportExportOperationType = 5;
                        ChangeConsoleIntCodeTasklet.this.mediaType = 6;
                        mountReadWrite = true;
                        Trace.trace(ChangeConsoleIntCodeTasklet.TRACE_MASKD, "Handle 'Retrieve code changes to DVD' choice.");
                    }
                    if (ChangeConsoleIntCodeTasklet.this.mediaType == 1) {
                        msgTextKey = "MCL0016";
                        msgTitleKey = "MCL8016";
                    } else {
                        msgTextKey = "MCL0017";
                        msgTitleKey = "MCL8017";
                    }
                    do {
                        repeatLoop = false;
                        boolean continueTask = ChangeConsoleIntCodeTasklet.this.isUserContinuingAfterMsg(msgTitleKey, msgTextKey, null, new LocalizableText[]{CommonMsgInterface.OK_BUTTON, CommonMsgInterface.CANCEL_BUTTON});
                        if (continueTask) {
                            MediaDevice mediaDevice = ChangeConsoleIntCodeTasklet.this.getMediaDevice(ChangeConsoleIntCodeTasklet.this.mediaType, mountReadWrite);
                            if (null == mediaDevice) {
                                response.noAction();
                                continue;
                            }
                            try {
                                ChangeConsoleIntCodeTasklet.this.mountPoint = mediaDevice.getMountPoint();
                                switch (ChangeConsoleIntCodeTasklet.this.savedImportExportOperationType) {
                                    case 1: 
                                    case 2: {
                                        boolean foundUpdates = ChangeConsoleIntCodeTasklet.this.isMediaApplicable(ChangeConsoleIntCodeTasklet.this.mountPoint, ChangeConsoleIntCodeTasklet.this.mediaType);
                                        ChangeConsoleIntCodeTasklet.this.releaseMediaDeviceLock();
                                        if (foundUpdates) {
                                            ChangeConsoleIntCodeTasklet.this.currentPanel = ChangeConsoleIntCodeTasklet.this.SelectIntCodeChgsPanelHandler;
                                            response.openModalChild("com.ibm.hwmca.base.updates.res.ChangeConsoleIntCodeRes", "SelectIntCodeChgsPanel", new SelectInternalCodeBean());
                                            break;
                                        }
                                        ChangeConsoleIntCodeTasklet.this.showMessage("MCL8116", "MCL0051");
                                        repeatLoop = true;
                                        break;
                                    }
                                    default: {
                                        Trace.trace(ChangeConsoleIntCodeTasklet.TRACE_MASKD, " [RetrieveIntCodePanelHandler.service()] mount point path: '" + ChangeConsoleIntCodeTasklet.this.mountPoint.getPath() + "'");
                                        Trace.trace(ChangeConsoleIntCodeTasklet.TRACE_MASKD, " [RetrieveIntCodePanelHandler.service()] composite name: '" + ChangeConsoleIntCodeTasklet.this.mountPoint.getPath() + File.separator + "taskinfo" + File.separator + "persist.txt'");
                                        File inputFile = new File(ChangeConsoleIntCodeTasklet.this.mountPoint.getPath() + File.separator + "taskinfo" + File.separator + "persist.txt");
                                        Trace.trace(ChangeConsoleIntCodeTasklet.TRACE_MASKD, " [RetrieveIntCodePanelHandler.service()] the media persisted file: '" + inputFile.getPath() + "'");
                                        ArrayList<String> defaultECNumbers = new ArrayList<String>();
                                        try {
                                            String line;
                                            BufferedReader in = new BufferedReader(new FileReader(inputFile));
                                            while (null != (line = in.readLine())) {
                                                defaultECNumbers.add(line);
                                            }
                                            in.close();
                                        }
                                        catch (IOException ioe) {
                                            Trace.trace(ChangeConsoleIntCodeTasklet.TRACE_MASKF, " [RetrieveIntCodePanelHandler.service()] caught IOException: " + ioe);
                                        }
                                        List suggestedULs = null;
                                        if (!defaultECNumbers.isEmpty()) {
                                            UpdateUtilities updateUtil = new UpdateUtilities();
                                            suggestedULs = updateUtil.getSuggestedUpdateLevelsForMedia(ChangeConsoleIntCodeTasklet.this.mountPoint, ChangeConsoleIntCodeTasklet.this.mediaType, defaultECNumbers);
                                        }
                                        ChangeConsoleIntCodeTasklet.this.releaseMediaDeviceLock();
                                        StartChgEndChgBean bean = new StartChgEndChgBean();
                                        bean.initializeWithServerData(suggestedULs);
                                        ChangeConsoleIntCodeTasklet.this.currentPanel = ChangeConsoleIntCodeTasklet.this.StartChgEndChgPanelHandler;
                                        response.openModalChild("com.ibm.hwmca.base.updates.res.ChangeConsoleIntCodeRes", "StartChgEndChgPanel", bean);
                                        break;
                                    }
                                }
                            }
                            catch (MediaDeviceException mde) {
                                Trace.trace(ChangeConsoleIntCodeTasklet.TRACE_MASKT, " [RetrieveIntCodePanelHandler.service()] caught exception: " + mde);
                                mde.printStackTrace();
                                ChangeConsoleIntCodeTasklet.this.releaseMediaDeviceLock();
                                ChangeConsoleIntCodeTasklet.this.showMessage("MCL8116", "MCL0018");
                                response.noAction();
                            }
                            catch (HException he) {
                                Trace.trace(ChangeConsoleIntCodeTasklet.TRACE_MASKT, " [RetrieveIntCodePanelHandler.service()] caught exception: " + he);
                                ChangeConsoleIntCodeTasklet.this.releaseMediaDeviceLock();
                                ChangeConsoleIntCodeTasklet.this.showMessage("MCL8116", "MCL0018");
                                response.noAction();
                            }
                            continue;
                        }
                        Trace.trace(ChangeConsoleIntCodeTasklet.TRACE_MASKF, " [RetrieveIntCodePanelHandler.service()] User must have canceled the 'insert media' panel.");
                        response.noAction();
                    } while (repeatLoop);
                } else if (radioButton.equalsIgnoreCase("RetrieveFromIBMChoice")) {
                    Trace.trace(ChangeConsoleIntCodeTasklet.TRACE_MASKD, "Handle 'Retrieve code changes from IBM support' choice.");
                    ChangeConsoleIntCodeTasklet.this.savedImportExportOperationType = 3;
                    ChangeConsoleIntCodeTasklet.this.currentPanel = ChangeConsoleIntCodeTasklet.this.SelectIntCodeChgsPanelHandler;
                    response.openModalChild("com.ibm.hwmca.base.updates.res.ChangeConsoleIntCodeRes", "SelectIntCodeChgsPanel", new SelectInternalCodeBean());
                } else {
                    Trace.trace(ChangeConsoleIntCodeTasklet.TRACE_MASKF, " [RetrieveIntCodePanelHandler.service()] Ignore unknown radio button '" + radioButton + "'");
                    response.noAction();
                }
            }
            Trace.trace(ChangeConsoleIntCodeTasklet.TRACE_MASKT, "<- ChangeConsoleIntCodeTasklet.RetrieveIntCodePanelHandler");
        }
    };
    private PanelHandler StartChgEndChgPanelHandler = new PanelHandler(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
            Trace.trace(ChangeConsoleIntCodeTasklet.TRACE_MASKT, "-> ChangeConsoleIntCodeTasklet.StartChgEndChgPanelHandler");
            if (request.isDisposed() || request.isCanceled()) {
                ChangeConsoleIntCodeTasklet.this.currentPanel = ChangeConsoleIntCodeTasklet.this.RetrieveIntCodePanelHandler;
                response.dispose();
            } else {
                List urList = (List)request.getData("userData");
                if (!urList.isEmpty()) {
                    if (ChangeConsoleIntCodeTasklet.this.savedImportExportOperationType == 4) {
                        ChangeConsoleIntCodeTasklet.this.mediaType = 1;
                    } else {
                        ChangeConsoleIntCodeTasklet.this.mediaType = 6;
                    }
                    MediaDevice mediaDevice = ChangeConsoleIntCodeTasklet.this.getMediaDevice(ChangeConsoleIntCodeTasklet.this.mediaType, true);
                    if (null == mediaDevice) {
                        Trace.trace(ChangeConsoleIntCodeTasklet.TRACE_MASKF, " [StartChgEndChgPanelHandler.service()] Unable to write out EC numbers to media file.");
                    } else {
                        try {
                            ChangeConsoleIntCodeTasklet.this.mountPoint = mediaDevice.getMountPoint();
                            File mediaDir = new File(ChangeConsoleIntCodeTasklet.this.mountPoint.getPath() + File.separator + "taskinfo");
                            if (!mediaDir.exists()) {
                                Trace.trace(ChangeConsoleIntCodeTasklet.TRACE_MASKD, " [StartChgEndChgPanelHandler.service()] Creating directory on media.");
                                mediaDir.mkdir();
                            }
                            Trace.trace(ChangeConsoleIntCodeTasklet.TRACE_MASKD, " [StartChgEndChgPanelHandler.service()] Ready to write file on media.");
                            File outputFile = new File(ChangeConsoleIntCodeTasklet.this.mountPoint.getPath() + File.separator + "taskinfo" + File.separator + "persist.txt");
                            BufferedWriter out = new BufferedWriter(new FileWriter(outputFile));
                            Iterator iterator = urList.iterator();
                            while (iterator.hasNext()) {
                                out.write(((UpdateRange)iterator.next()).getUpdateableComponentECNumber());
                                out.newLine();
                            }
                            out.close();
                        }
                        catch (MediaDeviceException mde) {
                            Trace.trace(ChangeConsoleIntCodeTasklet.TRACE_MASKT, " [StartChgEndChgPanelHandler.service()] caught exception: " + mde);
                            Trace.trace(ChangeConsoleIntCodeTasklet.TRACE_MASKT, " [StartChgEndChgPanelHandler.service()] Unable to write out EC numbers to media file.");
                            mde.printStackTrace();
                        }
                        catch (IOException ioe) {
                            Trace.trace(ChangeConsoleIntCodeTasklet.TRACE_MASKT, " [StartChgEndChgPanelHandler.service()] caught IOException: " + ioe);
                            Trace.trace(ChangeConsoleIntCodeTasklet.TRACE_MASKT, " [StartChgEndChgPanelHandler.service()] Unable to write out EC numbers to media file.");
                        }
                        finally {
                            ChangeConsoleIntCodeTasklet.this.releaseMediaDeviceLock();
                        }
                    }
                    ChangeConsoleIntCodeTasklet.this.performImportExport(response, urList);
                } else {
                    Trace.trace(ChangeConsoleIntCodeTasklet.TRACE_MASKF, " [StartChgEndChgPanelHandler.service()] Ignoring request since no valid EC number and level combinations specified.");
                    response.noAction();
                }
            }
            Trace.trace(ChangeConsoleIntCodeTasklet.TRACE_MASKT, "<- ChangeConsoleIntCodeTasklet.StartChgEndChgPanelHandler");
        }
    };

    public void destroy() {
        Trace.trace(TRACE_MASKD, " ******************************************");
        Trace.trace(TRACE_MASKD, " **                                     ***");
        Trace.trace(TRACE_MASKD, " **  In Change tasklet destroy()        ***");
        Trace.trace(TRACE_MASKD, " **                                     ***");
        Trace.trace(TRACE_MASKD, " ******************************************");
    }

    public ChangeConsoleIntCodeTasklet() {
        Trace.trace(TRACE_MASKT, "-> ChangeConsoleIntCodeTasklet.()");
        this.setExplicitTerminate(true);
        Trace.trace(TRACE_MASKT, "<- ChangeConsoleIntCodeTasklet.()");
    }

    public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> ChangeConsoleIntCodeTasklet.service()");
        try {
            String restart = (String)request.getData(DATA_RESTART);
            if (request.isInitialRequest() || null != restart) {
                this.showBusyDialog(new LocalizableText(BaseTextBundle.getBundleName(), "updates.changecons.busy.title"), new LocalizableText(BaseTextBundle.getBundleName(), "updates.changecons.busy.text"));
                this.theUpdateManager = UpdateManager.getUpdateManager();
                ChangeConsoleIntCodeBean bean = new ChangeConsoleIntCodeBean();
                bean.refreshData(this.getResponseData());
                this.destroyBusyDialog();
                this.currentPanel = this.ChgIntCodePanelHandler;
                response.replace("com.ibm.hwmca.base.updates.res.ChangeConsoleIntCodeRes", "ChgIntCodePanel", bean);
            } else {
                String refresh = (String)request.getData(DATA_REFRESH);
                if (null != refresh) {
                    Trace.trace(TRACE_MASKF, " [ChangeConsoleIntCodeTasklet.service()]  Refresh main panel.");
                    response.update(this.getResponseData());
                } else {
                    this.currentPanel.service(request, response);
                }
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKT, " [ChangeConsoleIntCodeTasklet.service()] caught exception: " + e);
            e.printStackTrace();
            new FrameworkLog(classLogInfo, -252, e).log();
            Trace.trace(TRACE_MASKT, " [ChangeConsoleIntCodeTasklet.service()] Terminate task due to unrecoverable error.");
            response.terminate();
        }
        Trace.trace(TRACE_MASKT, "<- ChangeConsoleIntCodeTasklet.service()");
    }

    private ChangeConsoleIntCodeResponseData getResponseData() {
        String textKey;
        Trace.trace(TRACE_MASKT, "-> ChangeConsoleIntCodeTasklet.getResponseData()");
        ChangeConsoleIntCodeResponseData responseData = new ChangeConsoleIntCodeResponseData();
        boolean changeManagementFlag = false;
        if (this.theUpdateManager.isUpdatingFullyEnabled()) {
            textKey = "updates.enabled.text";
            changeManagementFlag = true;
            ArrayList<Integer> state = new ArrayList<Integer>(1);
            state.add(new Integer(1));
            List collections = this.findCollectionsInState(state, true);
            if (!collections.isEmpty()) {
                responseData.setApplyFlag(true);
                responseData.setDeleteFlag(true);
            }
            state.clear();
            state.add(new Integer(2));
            collections = this.findCollectionsInState(state, true);
            if (!collections.isEmpty()) {
                responseData.setRejectFlag(true);
            }
            state.clear();
            state.add(new Integer(3));
            collections = this.findCollectionsInState(state, true);
            if (!collections.isEmpty()) {
                responseData.setApplyFlag(true);
                responseData.setRejectFlag(true);
            }
            state.clear();
            state.add(new Integer(5));
            collections = this.findCollectionsInState(state, true);
            if (!collections.isEmpty()) {
                responseData.setCommitFlag(true);
                responseData.setRejectFlag(true);
            }
            state.clear();
            state.add(new Integer(4));
            collections = this.findCollectionsInState(state, true);
            if (!collections.isEmpty()) {
                responseData.setApplyFlag(true);
            }
            List allUpdatesList = this.theUpdateManager.getTowerUpdates();
            boolean foundConfigSpecificUpdate = false;
            Iterator iterator = allUpdatesList.iterator();
            while (iterator.hasNext()) {
                Update update = (Update)iterator.next();
                if (!update.isConfigurationSpecific()) continue;
                foundConfigSpecificUpdate = true;
                break;
            }
            responseData.setSelectConfigSpecificFlag(foundConfigSpecificUpdate);
        } else {
            textKey = "updates.disabled.text";
        }
        LocalizableText status = new LocalizableText(BaseTextBundle.getBundleName(), textKey);
        responseData.setChangeManagementStatus(status);
        responseData.setChangeManagementFlag(changeManagementFlag);
        Trace.trace(TRACE_MASKT, "<- ChangeConsoleIntCodeTasklet.getResponseData()");
        return responseData;
    }

    private void performCommitUpdates(PanelTaskletResponse response, List ulList) {
        Trace.trace(TRACE_MASKT, "-> ChangeConsoleIntCodeTasklet.performCommitUpdates");
        boolean continueTask = this.isUserContinuingAfterMsg("MCL8001", "MCL0001", null, new LocalizableText[]{new LocalizableText(BaseTextBundle.getBundleName(), "updates.commit.button"), CommonMsgInterface.CANCEL_BUTTON, CommonMsgInterface.HELP_BUTTON});
        if (continueTask) {
            this.postRefreshRequest();
            UpdateUtilities updateUtil = new UpdateUtilities();
            try {
                if (null == ulList) {
                    updateUtil.commitAppliedCollections();
                } else {
                    updateUtil.commitAppliedCollections(ulList);
                }
                this.showMessage("MCL8002", "MCL0002");
            }
            catch (HException he) {
                Trace.trace(TRACE_MASKT, " [performCommitUpdates()] caught exception: " + he);
                LocalizableText details = updateUtil.getLastMessage();
                Trace.trace(TRACE_MASKD, " [performRejectUpdates()] Error details: '" + details + "'");
                Object[] substitutions = new LocalizableText[]{details};
                this.showMessage("MCL8116", "MCL0003", substitutions);
            }
            this.currentPanel = this.ChgIntCodePanelHandler;
            response.dispose("SelectIntCodeChgsPanel");
        } else {
            response.noAction();
        }
        Trace.trace(TRACE_MASKT, "<- ChangeConsoleIntCodeTasklet.performCommitUpdates");
    }

    private void performApplyUpdates(PanelTaskletResponse response, List ulList) {
        Trace.trace(TRACE_MASKT, "-> ChangeConsoleIntCodeTasklet.performApplyUpdates");
        boolean continueTask = this.isUserContinuingAfterMsg("MCL8001", "MCL0008", null, new LocalizableText[]{new LocalizableText(BaseTextBundle.getBundleName(), "updates.apply.button"), CommonMsgInterface.CANCEL_BUTTON, CommonMsgInterface.HELP_BUTTON});
        if (continueTask) {
            this.specificList = ulList;
            Runnable applyRun = new Runnable(){

                public void run() {
                    Trace.trace(ChangeConsoleIntCodeTasklet.TRACE_MASKT, "-> ChangeConsoleIntCodeTasklet.applyRun.run()");
                    ChangeConsoleIntCodeTasklet.this.doApplyUpdates();
                    Trace.trace(ChangeConsoleIntCodeTasklet.TRACE_MASKT, "<- ChangeConsoleIntCodeTasklet.applyRun.run()");
                }
            };
            Thread applyThread = new Thread(applyRun, "ChangeConsoleIntCodeTasklet");
            applyThread.start();
            this.currentPanel = this.ChgIntCodePanelHandler;
            response.dispose("ChgIntCodePanel");
        } else {
            response.noAction();
        }
        Trace.trace(TRACE_MASKT, "<- ChangeConsoleIntCodeTasklet.performApplyUpdates");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doApplyUpdates() {
        Trace.trace(TRACE_MASKT, "-> ChangeConsoleIntCodeTasklet.doApplyUpdates()");
        this.savedProgListener = new PanelTaskletProgressListener(this);
        this.startProgPanel(0L, new LocalizableText(BaseTextBundle.getBundleName(), "updates.applystart.text"));
        ChangeConsoleIntCodeTasklet changeConsoleIntCodeTasklet = this;
        synchronized (changeConsoleIntCodeTasklet) {
            progressDismissed = false;
            Trace.trace(TRACE_MASKF, "   ChangeConsoleIntCodeTasklet.doApplyUpdates() - perform the apply");
            UpdateUtilities updateUtil = new UpdateUtilities();
            boolean noException = true;
            try {
                if (null == this.specificList) {
                    updateUtil.applyStagedCollections();
                } else {
                    updateUtil.applyStagedCollections(this.specificList);
                }
            }
            catch (HException he) {
                Trace.trace(TRACE_MASKT, "   ChangeConsoleIntCodeTasklet.doApplyUpdates() - caught exception: " + he);
                noException = false;
                ProgressData progData = new ProgressData(new LocalizableText(BaseTextBundle.getBundleName(), "updates.applyfail.text"));
                progData.setCompletionStatus(3);
                LocalizableText details = updateUtil.getLastMessage();
                progData.setDetails(details);
                Trace.trace(TRACE_MASKD, "   ChangeConsoleIntCodeTasklet.doApplyUpdates() - update progress panel with failure indication.");
                Trace.trace(TRACE_MASKD, "   ChangeConsoleIntCodeTasklet.doApplyUpdates() - error details: '" + details + "'");
                ProgressUpdateEvent progUpdateEvent = new ProgressUpdateEvent(progData, PROGRESS_PANEL_ID);
                this.savedProgListener.updateProgress(progUpdateEvent);
                Trace.trace(TRACE_MASKD, "   ChangeConsoleIntCodeTasklet.doApplyUpdates() - end progress panel elapsed time.");
                this.savedProgListener.endProgress(new ProgressEndEvent(PROGRESS_PANEL_ID));
            }
            if (noException && updateUtil.isShutdownPending()) {
                ChangeMgmtInfo cmInfo = ChangeMgmtInfo.getChangeMgmtInfo();
                cmInfo.setActivateOperation(1);
                cmInfo.setMultiPass(updateUtil.isApplyOrRejectMultiPass());
                RestartManager rm = RestartManager.getRestartManager();
                rm.addPostInit(RESTART_CLASS);
                updateUtil.performShutdown();
            }
            while (!progressDismissed) {
                try {
                    Trace.trace(TRACE_MASKF, "   ChangeConsoleIntCodeTasklet.doApplyUpdates() - entering wait()");
                    this.wait();
                    Trace.trace(TRACE_MASKF, "   ChangeConsoleIntCodeTasklet.doApplyUpdates() - leaving wait()");
                }
                catch (InterruptedException exc) {}
            }
        }
        Trace.trace(TRACE_MASKF, "   ChangeConsoleIntCodeTasklet.doApplyUpdates() - progress window has been dismissed");
        PanelTaskletRequest restart = new PanelTaskletRequest();
        restart.setData(DATA_RESTART, DATA_RESTART);
        try {
            this.postRequest(null, restart);
        }
        catch (TaskletException te) {
            this.logException(te);
        }
        Trace.trace(TRACE_MASKF, "<- ChangeConsoleIntCodeTasklet.doApplyUpdates()");
    }

    private void performRejectUpdates(PanelTaskletResponse response, List ulList) {
        Trace.trace(TRACE_MASKT, "-> ChangeConsoleIntCodeTasklet.performRejectUpdates");
        boolean continueTask = this.isUserContinuingAfterMsg("MCL8001", "MCL0010", null, new LocalizableText[]{new LocalizableText(BaseTextBundle.getBundleName(), "updates.reject.button"), CommonMsgInterface.CANCEL_BUTTON, CommonMsgInterface.HELP_BUTTON});
        if (continueTask) {
            this.specificList = ulList;
            Runnable rejectRun = new Runnable(){

                public void run() {
                    Trace.trace(ChangeConsoleIntCodeTasklet.TRACE_MASKT, "-> ChangeConsoleIntCodeTasklet.rejectRun.run()");
                    ChangeConsoleIntCodeTasklet.this.doRejectUpdates();
                    Trace.trace(ChangeConsoleIntCodeTasklet.TRACE_MASKT, "<- ChangeConsoleIntCodeTasklet.rejectRun.run()");
                }
            };
            Thread rejectThread = new Thread(rejectRun, "ChangeConsoleIntCodeTasklet");
            rejectThread.start();
            this.currentPanel = this.ChgIntCodePanelHandler;
            response.dispose("ChgIntCodePanel");
        } else {
            response.noAction();
        }
        Trace.trace(TRACE_MASKT, "<- ChangeConsoleIntCodeTasklet.performRejectUpdates");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRejectUpdates() {
        Trace.trace(TRACE_MASKT, "-> ChangeConsoleIntCodeTasklet.doRejectUpdates()");
        this.savedProgListener = new PanelTaskletProgressListener(this);
        this.startProgPanel(0L, new LocalizableText(BaseTextBundle.getBundleName(), "updates.rejectstart.text"));
        ChangeConsoleIntCodeTasklet changeConsoleIntCodeTasklet = this;
        synchronized (changeConsoleIntCodeTasklet) {
            progressDismissed = false;
            Trace.trace(TRACE_MASKF, "   ChangeConsoleIntCodeTasklet.doRejectUpdates() - perform the reject");
            UpdateUtilities updateUtil = new UpdateUtilities();
            boolean noException = true;
            try {
                if (null == this.specificList) {
                    updateUtil.rejectAppliedCollections();
                } else {
                    updateUtil.rejectAppliedCollections(this.specificList);
                }
            }
            catch (HException he) {
                Trace.trace(TRACE_MASKT, "   ChangeConsoleIntCodeTasklet.doRejectUpdates() - caught exception: " + he);
                noException = false;
                ProgressData progData = new ProgressData(new LocalizableText(BaseTextBundle.getBundleName(), "updates.rejectfail.text"));
                progData.setCompletionStatus(3);
                LocalizableText details = updateUtil.getLastMessage();
                progData.setDetails(details);
                Trace.trace(TRACE_MASKD, "   ChangeConsoleIntCodeTasklet.doRejectUpdates() - update progress panel with failure indication.");
                Trace.trace(TRACE_MASKD, "   ChangeConsoleIntCodeTasklet.doRejectUpdates() - error details: '" + details + "'");
                ProgressUpdateEvent progUpdateEvent = new ProgressUpdateEvent(progData, PROGRESS_PANEL_ID);
                this.savedProgListener.updateProgress(progUpdateEvent);
                Trace.trace(TRACE_MASKD, "   ChangeConsoleIntCodeTasklet.doRejectUpdates() - end progress panel elapsed time.");
                this.savedProgListener.endProgress(new ProgressEndEvent(PROGRESS_PANEL_ID));
            }
            if (noException && updateUtil.isShutdownPending()) {
                ChangeMgmtInfo cmInfo = ChangeMgmtInfo.getChangeMgmtInfo();
                cmInfo.setActivateOperation(2);
                cmInfo.setMultiPass(updateUtil.isApplyOrRejectMultiPass());
                RestartManager rm = RestartManager.getRestartManager();
                rm.addPostInit(RESTART_CLASS);
                updateUtil.performShutdown();
            }
            while (!progressDismissed) {
                try {
                    Trace.trace(TRACE_MASKF, "   ChangeConsoleIntCodeTasklet.doRejectUpdates() - entering wait()");
                    this.wait();
                    Trace.trace(TRACE_MASKF, "   ChangeConsoleIntCodeTasklet.doRejectUpdates() - leaving wait()");
                }
                catch (InterruptedException exc) {}
            }
        }
        Trace.trace(TRACE_MASKF, "   ChangeConsoleIntCodeTasklet.doRejectUpdates() - progress window has been dismissed");
        PanelTaskletRequest restart = new PanelTaskletRequest();
        restart.setData(DATA_RESTART, DATA_RESTART);
        try {
            this.postRequest(null, restart);
        }
        catch (TaskletException te) {
            this.logException(te);
        }
        Trace.trace(TRACE_MASKF, "<- ChangeConsoleIntCodeTasklet.doRejectUpdates()");
    }

    private void performImportExport(PanelTaskletResponse response, List specificListIn) {
        MediaDevice mediaDevice;
        Trace.trace(TRACE_MASKT, "-> ChangeConsoleIntCodeTasklet.performImportExport");
        this.mediaType = 0;
        boolean mountReadWrite = false;
        String confirmationMsgKey = null;
        this.specificList = specificListIn;
        switch (this.savedImportExportOperationType) {
            case 1: {
                this.mediaType = 1;
                mountReadWrite = false;
                confirmationMsgKey = "MCL0011";
                this.progPanelStartMsg = new LocalizableText(BaseTextBundle.getBundleName(), "updates.importstart.text");
                break;
            }
            case 2: {
                this.mediaType = 6;
                mountReadWrite = false;
                confirmationMsgKey = "MCL0011";
                this.progPanelStartMsg = new LocalizableText(BaseTextBundle.getBundleName(), "updates.importstart.text");
                break;
            }
            case 4: {
                this.mediaType = 1;
                mountReadWrite = true;
                confirmationMsgKey = "MCL0013";
                this.progPanelStartMsg = new LocalizableText(BaseTextBundle.getBundleName(), "updates.exportstart.text");
                break;
            }
            case 5: {
                this.mediaType = 6;
                mountReadWrite = true;
                confirmationMsgKey = "MCL0013";
                this.progPanelStartMsg = new LocalizableText(BaseTextBundle.getBundleName(), "updates.exportstart.text");
                break;
            }
            default: {
                confirmationMsgKey = "MCL0012";
                this.progPanelStartMsg = new LocalizableText(BaseTextBundle.getBundleName(), "updates.importstart.text");
            }
        }
        UpdateUtilities updateUtil = new UpdateUtilities();
        boolean continueTask = true;
        this.estimatedDuration = new Long(0L);
        String[] estimatedTimeSubstitution = null;
        if (this.savedImportExportOperationType == 1 || this.savedImportExportOperationType == 2) {
            mediaDevice = this.getMediaDevice(this.mediaType, false);
            if (null != mediaDevice) {
                try {
                    this.mountPoint = mediaDevice.getMountPoint();
                }
                catch (MediaDeviceException mde) {
                    Trace.trace(TRACE_MASKT, " [performImportExport()] caught exception: " + mde);
                    continueTask = false;
                    this.showMessage("MCL8116", "MCL0018");
                }
            } else {
                continueTask = false;
            }
            if (continueTask) {
                Collection unstagedUpdates = new ArrayList();
                if (null == this.specificList) {
                    unstagedUpdates = updateUtil.queryUnstagedUpdatesOnMedia(this.mountPoint, this.mediaType);
                } else {
                    try {
                        unstagedUpdates = updateUtil.queryUnstagedUpdatesOnMedia(this.mountPoint, this.mediaType, this.specificList);
                    }
                    catch (SpecificRequestNotPossibleException srnpe) {
                        continueTask = false;
                        NumberFormat nf = NumberFormat.getInstance();
                        nf.setMinimumIntegerDigits(3);
                        String missingLevel = srnpe.getComponent() + "." + nf.format(srnpe.getMissing());
                        Object[] subs = new String[]{missingLevel};
                        this.showMessage("MCL8061", "MCL0061", subs);
                    }
                }
                if (continueTask) {
                    if (unstagedUpdates.isEmpty()) {
                        continueTask = false;
                        this.showMessage("MCL8035", "MCL0035");
                    } else {
                        this.estimatedDuration = new Long(unstagedUpdates.size() * 3);
                        estimatedTimeSubstitution = new String[]{this.estimatedDuration.toString()};
                    }
                }
            }
            this.releaseMediaDeviceLock();
        }
        if (continueTask) {
            continueTask = this.isUserContinuingAfterMsg("MCL8001", confirmationMsgKey, estimatedTimeSubstitution, new LocalizableText[]{new LocalizableText(BaseTextBundle.getBundleName(), "updates.importexport.button"), CommonMsgInterface.CANCEL_BUTTON, CommonMsgInterface.HELP_BUTTON});
        }
        if (continueTask) {
            if (this.savedImportExportOperationType != 3) {
                mediaDevice = this.getMediaDevice(this.mediaType, mountReadWrite);
                if (null != mediaDevice) {
                    try {
                        this.mountPoint = mediaDevice.getMountPoint();
                    }
                    catch (MediaDeviceException mde) {
                        Trace.trace(TRACE_MASKT, " [performImportExport()] caught exception: " + mde);
                        continueTask = false;
                        this.showMessage("MCL8116", "MCL0018");
                    }
                } else {
                    continueTask = false;
                }
            }
            if (continueTask) {
                Runnable progRun = new Runnable(){

                    public void run() {
                        Trace.trace(ChangeConsoleIntCodeTasklet.TRACE_MASKT, "-> ChangeConsoleIntCodeTasklet.progRun.run()");
                        ChangeConsoleIntCodeTasklet.this.doImportExport();
                        Trace.trace(ChangeConsoleIntCodeTasklet.TRACE_MASKT, "<- ChangeConsoleIntCodeTasklet.progRun.run()");
                    }
                };
                Thread progThread = new Thread(progRun, "ChangeConsoleIntCodeTasklet");
                progThread.start();
                this.currentPanel = this.ChgIntCodePanelHandler;
                response.dispose("ChgIntCodePanel");
                Trace.trace(TRACE_MASKF, "<- ChangeConsoleIntCodeTasklet.performImportExport()");
                return;
            }
            Trace.trace(TRACE_MASKD, " [performImportExport()] Stopping import/export processing.");
            response.noAction();
            this.releaseMediaDeviceLock();
        } else {
            Trace.trace(TRACE_MASKD, " [performImportExport()] Stopping import/export processing.");
            response.noAction();
        }
        Trace.trace(TRACE_MASKT, "<- ChangeConsoleIntCodeTasklet.performImportExport");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doImportExport() {
        Trace.trace(TRACE_MASKT, "-> ChangeConsoleIntCodeTasklet.doImportExport()");
        this.savedProgListener = new PanelTaskletProgressListener(this);
        this.startProgPanel(this.estimatedDuration, this.progPanelStartMsg);
        Trace.trace(TRACE_MASKF, "   ChangeConsoleIntCodeTasklet.doImportExport() - starting progress panel tasks");
        ChangeConsoleIntCodeTasklet changeConsoleIntCodeTasklet = this;
        synchronized (changeConsoleIntCodeTasklet) {
            int completionStatus;
            progressDismissed = false;
            boolean gotException = false;
            UpdateUtilities updateUtil = new UpdateUtilities();
            switch (this.savedImportExportOperationType) {
                case 1: 
                case 2: {
                    try {
                        if (null == this.specificList) {
                            updateUtil.importUnstagedCollectionsFromMedia(this.mountPoint, this.mediaType);
                            break;
                        }
                        updateUtil.importUnstagedCollectionsFromMedia(this.mountPoint, this.mediaType, this.specificList);
                    }
                    catch (HException he) {
                        Trace.trace(TRACE_MASKF, "   ChangeConsoleIntCodeTasklet.doImportExport() - caught exception: " + he);
                        gotException = true;
                    }
                    break;
                }
                case 4: 
                case 5: {
                    try {
                        updateUtil.exportRemoteUnstagedCollectionsToMedia(this.savedProgListener, this.mountPoint, this.mediaType, this.specificList, PROGRESS_PANEL_ID);
                    }
                    catch (HException he) {
                        Trace.trace(TRACE_MASKF, "   ChangeConsoleIntCodeTasklet.doImportExport() - caught exception: " + he);
                        gotException = true;
                    }
                    break;
                }
                default: {
                    try {
                        if (null == this.specificList) {
                            updateUtil.importRemoteUnstagedCollections();
                            break;
                        }
                        updateUtil.importRemoteUnstagedCollections(this.specificList);
                        break;
                    }
                    catch (HException he) {
                        Trace.trace(TRACE_MASKF, "ChangeConsoleIntCodeTasklet.doImportExport()caught exception: " + he);
                        gotException = true;
                    }
                }
            }
            this.releaseMediaDeviceLock();
            LocalizableText completionMessage = null;
            completionMessage = updateUtil.getLastMessage();
            if (gotException) {
                if (null == completionMessage) {
                    completionMessage = new LocalizableText(BaseTextBundle.getBundleName(), "updates.importexportfail.text");
                }
                completionStatus = 3;
            } else {
                if (null == completionMessage) {
                    completionMessage = new LocalizableText(BaseTextBundle.getBundleName(), "updates.importexportdone.text");
                }
                completionStatus = 1;
            }
            ProgressData progData = new ProgressData(completionMessage);
            progData.setCompletionStatus(completionStatus);
            ProgressUpdateEvent progUpdateEvent = new ProgressUpdateEvent(progData, PROGRESS_PANEL_ID);
            this.savedProgListener.updateProgress(progUpdateEvent);
            Trace.trace(TRACE_MASKD, "   ChangeConsoleIntCodeTasklet.doImportExport() - tell progress panel we're done");
            this.savedProgListener.endProgress(new ProgressEndEvent(PROGRESS_PANEL_ID));
            while (!progressDismissed) {
                try {
                    Trace.trace(TRACE_MASKF, "   ChangeConsoleIntCodeTasklet.doImportExport() - entering wait()");
                    this.wait();
                    Trace.trace(TRACE_MASKF, "   ChangeConsoleIntCodeTasklet.doImportExport() - leaving wait()");
                }
                catch (InterruptedException exc) {}
            }
        }
        Trace.trace(TRACE_MASKF, "   ChangeConsoleIntCodeTasklet.doImportExport() - progress window has been dismissed");
        PanelTaskletRequest restart = new PanelTaskletRequest();
        restart.setData(DATA_RESTART, DATA_RESTART);
        try {
            this.postRequest(null, restart);
        }
        catch (TaskletException te) {
            this.logException(te);
        }
        Trace.trace(TRACE_MASKF, "<- ChangeConsoleIntCodeTasklet.doImportExport()");
    }

    private void performDeleteUpdates(PanelTaskletResponse response, List ulList) {
        Trace.trace(TRACE_MASKT, "-> ChangeConsoleIntCodeTasklet.performDeleteUpdates");
        boolean continueTask = this.isUserContinuingAfterMsg("MCL8001", "MCL0024", null, new LocalizableText[]{new LocalizableText(BaseTextBundle.getBundleName(), "updates.delete.button"), CommonMsgInterface.CANCEL_BUTTON, CommonMsgInterface.HELP_BUTTON});
        if (continueTask) {
            this.postRefreshRequest();
            UpdateUtilities updateUtil = new UpdateUtilities();
            try {
                if (null == ulList) {
                    updateUtil.deleteStagedCollections();
                } else {
                    updateUtil.deleteStagedCollections(ulList);
                }
                this.showMessage("MCL8025", "MCL0025");
            }
            catch (HException he) {
                Trace.trace(TRACE_MASKT, " [performDeleteUpdates()] caught exception: " + he);
                LocalizableText details = updateUtil.getLastMessage();
                Trace.trace(TRACE_MASKD, " [performRejectUpdates()] Error details: '" + details + "'");
                Object[] substitutions = new String[]{details.toString()};
                this.showMessage("MCL8116", "MCL0026", substitutions);
            }
            this.currentPanel = this.ChgIntCodePanelHandler;
            response.dispose("SelectIntCodeChgsPanel");
        } else {
            response.noAction();
        }
        Trace.trace(TRACE_MASKT, "<- ChangeConsoleIntCodeTasklet.performDeleteUpdates");
    }

    private void performCheckDependencies(PanelTaskletResponse response, List ulList) {
        Trace.trace(TRACE_MASKT, "-> ChangeConsoleIntCodeTasklet.performCheckDependencies");
        boolean gotError = false;
        List operationSteps = null;
        try {
            switch (this.savedCheckDependencyType) {
                case 1: {
                    ArrayList<Integer> applyStates = new ArrayList<Integer>(2);
                    applyStates.add(new Integer(1));
                    applyStates.add(new Integer(3));
                    List applyCollections = this.findCollectionsInState(applyStates, false);
                    ulList = this.getLevelsForCollections(applyCollections);
                    operationSteps = this.theUpdateManager.arrangeDependenciesForApply(ulList);
                    break;
                }
                case 2: {
                    ArrayList<Integer> rejectState = new ArrayList<Integer>(1);
                    rejectState.add(new Integer(5));
                    List rejectCollections = this.findCollectionsInState(rejectState, false);
                    ulList = this.getLevelsForCollections(rejectCollections);
                    operationSteps = this.theUpdateManager.arrangeDependenciesForReject(ulList);
                    break;
                }
                case 3: {
                    operationSteps = this.theUpdateManager.arrangeDependenciesForApply(ulList);
                    break;
                }
                case 4: {
                    operationSteps = this.theUpdateManager.arrangeDependenciesForReject(ulList);
                    break;
                }
                default: {
                    operationSteps = this.theUpdateManager.arrangeDependenciesForCommit(ulList);
                    break;
                }
            }
        }
        catch (MissingDependencyException mde) {
            Trace.trace(TRACE_MASKD, " [performCheckDependencies()] caught exception: " + mde);
            gotError = true;
            DependCheckingFailBean bean = new DependCheckingFailBean();
            bean.initializeWithServerData(mde.getMissingDependencies(), new Integer(this.savedCheckDependencyType));
            this.currentPanel = this.DependencyCheckingFailurePanelHandler;
            response.openModalChild("com.ibm.hwmca.base.updates.res.ChangeConsoleIntCodeRes", "DependencyCheckingFailuresNotePanel", bean);
        }
        catch (DependencyException de) {
            gotError = true;
            Trace.trace(TRACE_MASKD, " [performCheckDependencies()] caught exception: " + de);
            de.printStackTrace();
            response.noAction();
        }
        if (!gotError) {
            if (operationSteps.size() > 1) {
                Object[] substitutions;
                switch (this.savedCheckDependencyType) {
                    case 1: 
                    case 3: {
                        substitutions = new String[]{"Install and Activation", "Install and Activate"};
                        break;
                    }
                    case 2: 
                    case 4: {
                        substitutions = new String[]{"Remove and Activation", "Remove and Activate"};
                        break;
                    }
                    default: {
                        substitutions = new String[]{"Accept", "Accept"};
                    }
                }
                this.showMessage("MCL8004", "MCL0005", substitutions);
            } else {
                this.showMessage("MCL8004", "MCL0004");
            }
            this.currentPanel = this.ChgIntCodePanelHandler;
            response.dispose("CheckDependenciesPanel");
        }
        Trace.trace(TRACE_MASKT, "<- ChangeConsoleIntCodeTasklet.performCheckDependencies");
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean isUpdateLevelListValid(List ulList) {
        String classAndMethod = "ChangeConsoleIntCodeTasklet.isUpdateLevelListValid()";
        Trace.trace(TRACE_MASKT, "-> " + classAndMethod);
        boolean isValid = false;
        Iterator iterator = ulList.iterator();
        while (iterator.hasNext()) {
            isValid = false;
            UpdateLevel ul = (UpdateLevel)iterator.next();
            String specifiedECNumber = ul.getUpdateableComponentECNumber();
            Trace.trace(TRACE_MASKF, "   " + classAndMethod + "The specified EC number is: " + specifiedECNumber);
            UpdateableComponent uc = this.theUpdateManager.getComponentByECNumber(specifiedECNumber);
            if (null == uc) {
                Trace.trace(TRACE_MASKF, "   " + classAndMethod + " - Got a null updateable component for the EC number.");
                if (this.savedTrack == 6 && (this.savedImportExportOperationType == 4 || this.savedImportExportOperationType == 5)) {
                    isValid = true;
                } else {
                    this.showMessage("MCL8027", "MCL0036", new String[]{specifiedECNumber});
                }
            } else {
                int specifiedLevel = ul.getLevel();
                Trace.trace(TRACE_MASKF, "   " + classAndMethod + " - The specified level is: " + specifiedLevel);
                Trace.trace(TRACE_MASKF, "   " + classAndMethod + " - The saved track is: " + this.savedTrack);
                Trace.trace(TRACE_MASKF, "   " + classAndMethod + " - The current staged level: " + uc.getStagedLevel());
                Trace.trace(TRACE_MASKF, "   " + classAndMethod + " - The current applied level: " + uc.getAppliedLevel());
                Trace.trace(TRACE_MASKF, "   " + classAndMethod + " - The current committed level: " + uc.getCommittedLevel());
                if (specifiedLevel == -1) {
                    isValid = true;
                } else {
                    switch (this.savedTrack) {
                        case 6: {
                            Trace.trace(TRACE_MASKF, "   " + classAndMethod + " - The saved import/export track is: " + this.savedImportExportOperationType);
                            switch (this.savedImportExportOperationType) {
                                case 1: 
                                case 2: 
                                case 3: {
                                    if (specifiedLevel <= uc.getStagedLevel()) break;
                                    isValid = true;
                                    break;
                                }
                            }
                            break;
                        }
                        case 8: {
                            if (specifiedLevel > uc.getStagedLevel() || specifiedLevel <= uc.getCommittedLevel()) break;
                            isValid = true;
                            break;
                        }
                        case 3: {
                            if (specifiedLevel > uc.getStagedLevel() || specifiedLevel <= uc.getAppliedLevel()) break;
                            isValid = true;
                            break;
                        }
                        case 1: {
                            if (specifiedLevel > uc.getAppliedLevel() || specifiedLevel <= uc.getCommittedLevel()) break;
                            isValid = true;
                            break;
                        }
                        case 5: {
                            if (specifiedLevel > uc.getAppliedLevel() || specifiedLevel <= uc.getCommittedLevel()) break;
                            isValid = true;
                            break;
                        }
                        case 2: {
                            Trace.trace(TRACE_MASKF, "   " + classAndMethod + " - The saved check dependency type is: " + this.savedCheckDependencyType);
                            switch (this.savedCheckDependencyType) {
                                case 5: {
                                    if (specifiedLevel > uc.getAppliedLevel() || specifiedLevel <= uc.getCommittedLevel()) break;
                                    isValid = true;
                                    break;
                                }
                                case 3: {
                                    if (specifiedLevel > uc.getStagedLevel() || specifiedLevel <= uc.getAppliedLevel()) break;
                                    isValid = true;
                                    break;
                                }
                                case 4: {
                                    if (specifiedLevel > uc.getAppliedLevel() || specifiedLevel <= uc.getCommittedLevel()) break;
                                    isValid = true;
                                }
                            }
                            break;
                        }
                    }
                    if (!isValid) {
                        this.showMessage("MCL8027", "MCL0037", new String[]{specifiedECNumber});
                    }
                }
            }
            if (isValid) continue;
        }
        Trace.trace(TRACE_MASKT, "<- " + classAndMethod + " - " + isValid);
        return isValid;
    }

    private void startProgPanel(long duration, LocalizableText text) {
        Trace.trace(TRACE_MASKT, "-> ChangeConsoleIntCodeTasklet.startProgPanel");
        ProgressStartEvent startEvent = new ProgressStartEvent(new BaseMessageTitle("MCL8111"), new ProgressData[]{new ProgressData()}, duration * 60L, text, PROGRESS_PANEL_ID, (ProgressCancelListener)null, (ProgressEndedListener)this);
        Trace.trace(TRACE_MASKD, " [startProgPanel()] Start progress panel.");
        this.savedProgListener.startProgress(startEvent);
        Trace.trace(TRACE_MASKT, "<- ChangeConsoleIntCodeTasklet.startProgPanel");
    }

    private List findCollectionsInState(List states, boolean findJustOne) {
        Trace.trace(TRACE_MASKT, "<> ChangeConsoleIntCodeTasklet.findCollectionsInState");
        ArrayList<UpdateCollection> collections = new ArrayList<UpdateCollection>();
        boolean foundOne = false;
        List components = this.theUpdateManager.getTowerUpdateableComponents();
        Iterator iterator = components.iterator();
        while (iterator.hasNext()) {
            UpdateableComponent component = (UpdateableComponent)iterator.next();
            List updateCollections = component.getUpdateCollections();
            Iterator jiterator = updateCollections.iterator();
            while (jiterator.hasNext()) {
                UpdateCollection collection = (UpdateCollection)jiterator.next();
                int collectionState = collection.getState();
                Iterator kiterator = states.iterator();
                while (kiterator.hasNext()) {
                    int searchState = (Integer)kiterator.next();
                    if (searchState != collectionState) continue;
                    collections.add(collection);
                    if (!findJustOne) continue;
                    foundOne = true;
                    break;
                }
                if (!foundOne) continue;
                break;
            }
            if (!foundOne) continue;
            break;
        }
        return collections;
    }

    private List getLevelsForCollections(List collections) {
        Trace.trace(TRACE_MASKT, "<> ChangeConsoleIntCodeTasklet.getLevelsForCollections");
        ArrayList<UpdateLevel> updateLevels = new ArrayList<UpdateLevel>();
        Iterator iterator = collections.iterator();
        while (iterator.hasNext()) {
            UpdateCollection collection = (UpdateCollection)iterator.next();
            String ecNumber = collection.getUpdateableComponent().getECNumber();
            String level = collection.getDisplayableId();
            updateLevels.add(new UpdateLevel(ecNumber, Integer.parseInt(level)));
        }
        return updateLevels;
    }

    private MediaServicesUtil getMediaServicesUtil() {
        if (null == this.savedMediaServUtil) {
            this.savedMediaServUtil = new MediaServicesUtil(this);
        }
        return this.savedMediaServUtil;
    }

    private MediaDevice getMediaDevice(int mediaType, boolean mountReadWrite) {
        Trace.trace(TRACE_MASKT, "->ChangeConsoleIntCodeTasklet.getMediaDevice()");
        MediaDevice mediaDevice = null;
        try {
            mediaDevice = this.getMediaServicesUtil().prepareMedia(mediaType, new LocalizableText(BaseTextBundle.getBundleName(), "updates.changecons.mediaservices.name"), mountReadWrite, null);
        }
        catch (MediaServicesUtilException msue) {
            Trace.trace(TRACE_MASKT, " [getMediaDevice()] caught exception: " + msue);
            Trace.trace(TRACE_MASKT, " [getMediaDevice()] The exception type is: " + Integer.toString(msue.getErrorType()));
            if (msue.getErrorType() != 11) {
                this.showMessage("MCL8116", "MCL0018");
            }
            this.releaseMediaDeviceLock();
        }
        if (null == mediaDevice) {
            Trace.trace(TRACE_MASKD, " [getMediaDevice()] returning a NULL media device.");
        }
        Trace.trace(TRACE_MASKT, "<- ChangeConsoleIntCodeTasklet.getMediaDevice()");
        return mediaDevice;
    }

    private void releaseMediaDeviceLock() {
        if (null != this.savedMediaServUtil) {
            try {
                Trace.trace(TRACE_MASKD, " [ChangeConsoleIntCodeTasklet.releaseMediaDeviceLock()]Releasing media device lock.");
                this.savedMediaServUtil.releaseMedia();
            }
            catch (MediaServicesUtilException msue) {
                Trace.trace(TRACE_MASKD, " [releaseMediaDeviceLock()] caught exception: " + msue);
                Trace.trace(TRACE_MASKD, " [releaseMediaDeviceLock()] The exception type is: " + Integer.toString(msue.getErrorType()));
            }
        }
    }

    private boolean isMediaApplicable(File mountPoint, int mediaType) {
        boolean applicableUpdates = false;
        List updatersList = this.getAllUpdaters();
        Iterator iterator = updatersList.iterator();
        while (iterator.hasNext()) {
            if (!((Updater)iterator.next()).isMediaApplicable(mountPoint, mediaType)) continue;
            applicableUpdates = true;
            break;
        }
        return applicableUpdates;
    }

    private List getAllUpdaters() {
        if (null == this.allUpdaters) {
            List allUpdatesOwners = this.theUpdateManager.getTowerUpdatesOwners();
            Trace.trace(TRACE_MASKD, " [getAllUpdaters] number of UpdatesOwners known to all towers: " + allUpdatesOwners.size());
            this.allUpdaters = new ArrayList();
            Iterator iterator = allUpdatesOwners.iterator();
            while (iterator.hasNext()) {
                this.allUpdaters.add(((UpdatesOwner)iterator.next()).getUpdaterInstance());
            }
            Trace.trace(TRACE_MASKD, " [getAllUpdaters] number of Updater objects being returned: " + this.allUpdaters.size());
        }
        return this.allUpdaters;
    }

    private boolean isUserContinuingAfterMsg(String titleKey, String messageKey, String[] substitutions, LocalizableText[] options) {
        Trace.trace(TRACE_MASKT, "-> ChangeConsoleIntCodeTasklet.isUserContinuingAfterMsg");
        boolean firstButtonFlag = false;
        LocalizableText buttonPressed = this.showMessage(titleKey, messageKey, substitutions, options);
        if (null != buttonPressed) {
            Trace.trace(TRACE_MASKD, " [isUserContinuingAfterMsg] Button pressed on message box was '" + buttonPressed + "'");
        }
        if (null != buttonPressed) {
            if (null != options) {
                if (buttonPressed.toString().equals(options[0].toString())) {
                    firstButtonFlag = true;
                }
            } else if (buttonPressed.toString().equals(CommonMsgInterface.OK_BUTTON.toString()) || buttonPressed.toString().equals(CommonMsgInterface.YES_BUTTON.toString())) {
                firstButtonFlag = true;
            }
        }
        Trace.trace(TRACE_MASKF, " [isUserContinuingAfterMsg] returning '" + firstButtonFlag + "'");
        Trace.trace(TRACE_MASKT, "<- ChangeConsoleIntCodeTasklet.isUserContinuingAfterMsg");
        return firstButtonFlag;
    }

    private void postRefreshRequest() {
        Trace.trace(TRACE_MASKT, "-> ChangeConsoleIntCodeTasklet.postRefreshRequest()");
        PanelTaskletRequest newRequest = new PanelTaskletRequest("server");
        newRequest.setData(DATA_REFRESH, DATA_REFRESH);
        try {
            this.postRequest("ChgIntCodePanel", newRequest);
        }
        catch (TaskletException te) {
            Trace.trace(TRACE_MASKD, " [postRefreshRequest()] caught exception: " + te);
            te.printStackTrace();
        }
        Trace.trace(TRACE_MASKT, "<- ChangeConsoleIntCodeTasklet.postRefreshRequest()");
    }

    private void showMessage(String titleKey, String messageKey) {
        this.showMessage(titleKey, messageKey, null);
    }

    private void showMessage(String titleKey, String messageKey, Object[] substitutions) {
        this.showMessage(titleKey, messageKey, substitutions, null);
    }

    private LocalizableText showMessage(String titleKey, String messageKey, Object[] substitutions, LocalizableText[] options) {
        Trace.trace(TRACE_MASKT, "<> ChangeConsoleIntCodeTasklet.showMessage");
        LocalizableText buttonPressed = null;
        try {
            BaseMessageText message = null == substitutions ? new BaseMessageText(messageKey) : new BaseMessageText(messageKey, substitutions);
            buttonPressed = this.showMessageBox(true, new BaseMessageTitle(titleKey), message, null, options);
        }
        catch (TaskletException e) {
            Trace.trace(TRACE_MASKF, " [showMessage] Exception working with message box!");
        }
        return buttonPressed;
    }

    public void logException(Throwable throwable) {
        Trace.trace(TRACE_MASKT, "-> ChangeConsoleIntCodeTasklet.logException()");
        Trace.trace(TRACE_MASKT, "   processing exception: " + throwable);
        new FrameworkLog(classLogInfo, -253, throwable).log();
        Trace.trace(TRACE_MASKT, "<- ChangeConsoleIntCodeTasklet.logException()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void progressEnded(String id) {
        Trace.trace(TRACE_MASKT, "-> ChangeConsoleIntCodeTasklet.progressEnded()");
        ChangeConsoleIntCodeTasklet changeConsoleIntCodeTasklet = this;
        synchronized (changeConsoleIntCodeTasklet) {
            progressDismissed = true;
            Trace.trace(TRACE_MASKF, " [progressEnded()] entering notifyAll()");
            this.notifyAll();
            Trace.trace(TRACE_MASKF, " [progressEnded()] leaving notifyAll()");
        }
        Trace.trace(TRACE_MASKT, "<- ChangeConsoleIntCodeTasklet.progressEnded()");
    }

    public boolean isBusyDesired() {
        Trace.trace(TRACE_MASKT, "<> ChangeConsoleIntCodeTasklet.isBusyDesired() - " + this.isBusyDesiredForMediaOperations);
        return this.isBusyDesiredForMediaOperations;
    }

    public LocalizableText getBusyMessage() {
        Trace.trace(TRACE_MASKT, "<> ChangeConsoleIntCodeTasklet.getBusyMessage() -  returning [" + this.busyMessage + "]");
        return this.busyMessage;
    }

    public PanelTasklet getPanelTasklet() {
        Trace.trace(TRACE_MASKT, "<> ChangeConsoleIntCodeTasklet.getPanelTasklet() -  returning ourself");
        return this;
    }

    static {
        progressWaiters = new Object();
        classLogInfo = new FrameworkClassLogInfo(2, "ChangeConsoleIntCodeTasklet");
    }

    static interface PanelHandler {
        public void service(PanelTaskletRequest var1, PanelTaskletResponse var2) throws TaskletException;
    }
}

